/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.api.SNMPTrap;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemCustomerNotifier;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.snmp.SnmpTrap;
import com.ibm.hwmca.fw.snmp.SnmpTrapSender;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.PIProblemDataConstants;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PIProblemCustomerNotifier
implements ProblemCustomerNotifier,
PIProblemDataConstants,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemCustomerNotifier] ";

    public void notifyCustomer(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] notifyCustomer");
        try {
            PIProblemCustomerNotifier.ESAnotifyCustomer(problem, true);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] notifyCustomer HException: ");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public void repNotifyCustomer(Problem problem) {
        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] repNotifyCustomer");
        try {
            PIProblemCustomerNotifier.ESAnotifyCustomer(problem, false);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] repNotifyCustomer HException: ");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private static void ESAnotifyCustomer(Problem problem, boolean snmpFlag) throws HException {
        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] ESAnotifyCustomer");
        if (ServiceAgentUtils.isOEM()) {
            ServiceAgentUtils.notifyOEM("ProblemOpen", problem);
        } else if (problem instanceof PIProblem) {
            PIProblem theProblem = (PIProblem)problem;
            if (snmpFlag) {
                String trapEnterpriseID = null;
                String trapKey = "";
                short trapCode = 0;
                HashMap<String, String> trapData = null;
                if (ServiceAgentUtils.getHmcType().equals("ipHMC")) {
                    String partitionName;
                    SaelDataEvent sael;
                    trapCode = 3;
                    trapKey = "Trap3";
                    trapEnterpriseID = "1.3.6.1.4.1.2.6.201";
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z", Locale.US);
                    String datetime = df.format(new Date(theProblem.getFirstReportedTimestamp()));
                    String reportingMTMS = "n/a";
                    PASystem system = theProblem.getReportingRemoteMachineSystem();
                    if (system != null) {
                        reportingMTMS = system.getMachineType() + "-" + system.getMachineModel() + "*" + system.getMachineSerial();
                    }
                    String lparName = "n/a";
                    CommonDataEvent primaryDataEvent = theProblem.getPrimaryDataEvent();
                    if (primaryDataEvent != null && primaryDataEvent instanceof SaelDataEvent && (sael = (SaelDataEvent)primaryDataEvent) != null && (partitionName = sael.getPartitionName()) != null && partitionName.length() > 0) {
                        lparName = partitionName;
                    }
                    String failingMTMS = "n/a";
                    system = theProblem.getFailingSystem();
                    if (system != null) {
                        failingMTMS = system.getMachineType() + "-" + system.getMachineModel() + "*" + system.getMachineSerial();
                    }
                    String src = "n/a";
                    if (theProblem.getRefcode() != null && theProblem.getRefcode().length() > 0) {
                        src = theProblem.getRefcode();
                    }
                    String eventText = "n/a";
                    LocalizableText desc = theProblem.getDescription();
                    if (desc != null && desc.toString(Locale.US) != null && desc.toString(Locale.US).length() > 0) {
                        eventText = eventText.length() > 79 ? desc.toString(Locale.US).substring(0, 79) : desc.toString(Locale.US);
                    }
                    String fruData = "";
                    List frus = theProblem.getParts();
                    if (frus != null && frus.size() > 0) {
                        int fruCount = frus.size();
                        Iterator it = frus.iterator();
                        for (int i = 0; i < fruCount; ++i) {
                            CommonPaFru fru = (CommonPaFru)it.next();
                            fruData = fruData + "Fru" + String.valueOf(i + 1) + "Info=Description=[" + fru.getDescription() + "]PartNumber[" + fru.getPartNumber() + "]\n";
                        }
                    }
                    String cpsSystemSendTrap = "cpsSystemNotifyTrap='" + datetime + "'\n" + "Manufacturer=IBM" + "\n" + "ReportingMTMS=" + reportingMTMS + "\n" + "ProbNm=" + String.valueOf(theProblem.getProblemNumber()) + "\n" + "LparName=" + lparName + "\n" + "FailingEnclosureMTMS=" + failingMTMS + "\n" + "SRC=" + src + "\n" + "EventText=" + eventText + "\n" + fruData;
                    trapData = new HashMap<String, String>();
                    trapData.put("3", cpsSystemSendTrap);
                } else {
                    trapCode = theProblem.getTrapCode();
                    trapKey = theProblem.getTrapKey();
                    trapEnterpriseID = theProblem.getTrapEnterpriseID();
                    trapData = theProblem.getTrapData();
                }
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] trapEnterpriseID[" + trapEnterpriseID + "]");
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier]         trapCode[" + trapCode + "]");
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier]         trapData[" + trapData + "]");
                if (trapEnterpriseID != null) {
                    SnmpTrap trap = new SnmpTrap(trapEnterpriseID, trapCode);
                    if (trapData != null) {
                        Iterator i = trapData.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] Map key[" + e.getKey() + "] value[" + e.getValue() + "]");
                            trap.addVarBind(new SNMPTrap.VarBind((String)e.getKey(), e.getValue()));
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] trapData was null");
                    }
                    try {
                        SnmpTrapSender.sendTrapToConfiguredHosts(trap, trapKey, "public");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] Trap exception");
                        Trace.trace(TRACE_MASKF, e);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] trapEnterpriseID was null");
                }
            }
            if (ServiceAgentUtils.getEmailSetting()) {
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] email enabled");
                if (theProblem.isNotifyCustomer()) {
                    ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
                    boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
                    if (!RSFSetting || !theProblem.isCallHome() || theProblem.getProblemData().get("pdc_ESA_STATUS") != null) {
                        String calledhome = "N";
                        if (theProblem.isCallHome()) {
                            calledhome = "Y";
                        }
                        String from = "";
                        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                            from = from + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] from: " + from);
                        String failingsystem = "";
                        if (theProblem.getReportingRemoteMachineSystem() != null && theProblem.getReportingRemoteMachineSystem().getMOSystemName() != null) {
                            failingsystem = theProblem.getReportingRemoteMachineSystem().getMOSystemName();
                        }
                        if (networkInfo != null && failingsystem.length() == 0) {
                            failingsystem = networkInfo.getComputerName();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] failingsystem: " + failingsystem);
                        String failingmtms = "";
                        if (theProblem.getFailingSystem().getMTMS() != null) {
                            failingmtms = theProblem.getFailingSystem().getMTMS();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] failingmtms: " + failingmtms);
                        String refcode = "";
                        if (theProblem.getRefcode() != null) {
                            refcode = theProblem.getRefcode();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] refcode: " + refcode);
                        String description = "";
                        String[] nlsMessages = theProblem.getNlsMessages();
                        if (nlsMessages != null) {
                            description = nlsMessages[0];
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] description: " + description);
                        String lastOccurred = "";
                        long lastReported = theProblem.getLastReportedTimestamp();
                        if (lastReported > 0L) {
                            SimpleDateFormat df = new SimpleDateFormat();
                            lastOccurred = df.format(new Date(lastReported));
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] lastOccurred: " + lastOccurred);
                        LocalizableText currentStatus = (LocalizableText)theProblem.getProblemData().get("pdc_ESA_STATUS");
                        if (currentStatus == null) {
                            currentStatus = new LocalizableText(" ");
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] currentStatus: " + currentStatus);
                        String pmh = "n/a";
                        if (theProblem.getPMH() != null) {
                            pmh = theProblem.getPMH();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] pmh: " + pmh);
                        LocalizableText PMRDetails = (LocalizableText)theProblem.getProblemData().get("pdc_ESA_PMRSTATUS");
                        if (PMRDetails == null) {
                            PMRDetails = new LocalizableText(" ");
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] PMRDetails: " + PMRDetails);
                        String message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.reportingsystem", new String[]{failingsystem}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.mtms", new String[]{failingmtms}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problemnumber", new String[]{String.valueOf(theProblem.getProblemNumber())}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.error", new String[]{refcode}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.description", new String[]{description}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.lastoccurred", new String[]{lastOccurred}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.currentstatus", new String[]{currentStatus.toString()}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.pmrnumber", new String[]{pmh}).toString() + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.pmrdetails", new String[]{PMRDetails.toString()}).toString();
                        int rc = ServiceAgentUtils.ESASendEmailMsg(calledhome, new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problemreport.subject", new String[]{from}), new LocalizableText(message));
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] customerNotify disabled");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] email disabled");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] not a PIProblem");
        }
    }
}

